"use client";

import "./ShopQuickFilters.css";
import { usePathname } from "next/navigation";
import { useEffect, useState } from "react";
import FilterMobile from "../customSvgVectors/FilterMobile";
import MobileFilters from "./MobileFilters";
import { mobileModel } from "react-device-detect";

const ShopQuickFilters = ({ allProducts, setAllProducts, setCurrentPage }) => {
  const path = usePathname(),
    [openMobileFilters, setOpenMobileFilters] = useState(false),
    sortHandler = (type, direction = null) => {
      let backUp = [...allProducts],
        sortedBackUp = backUp.sort((a, b) => {
          if (type === "price") {
            let aPrice = a.price,
              bPrice = b.price;
            if (direction === "toMin") {
              return bPrice - aPrice;
            } else {
              return aPrice - bPrice;
            }
          }
          if (type === "discount") {
            let aPrice = a.discount,
              bPrice = b.discount;
            return bPrice - aPrice;
          }
          if (type === "rating") {
            let aRating = a.rating,
              bRating = b.rating;
            return bRating - aRating;
          }
          if (type === "date") {
            return b.created_at.localeCompare(a.created_at);
          }
        });
      setAllProducts(sortedBackUp);
    };

  useEffect(() => {
    const sortBtns = document.querySelectorAll(".filter-labels input");
    sortBtns.forEach((input, index) => {
      index !== 0 ? (input.checked = false) : null;
    });
  }, [path]);
  useEffect(() => {
    if (openMobileFilters === true) {
      document.body.style.overflowY = "hidden";
    } else {
      document.body.style.overflowY = "auto";
    }
  }, [openMobileFilters]);
  return (
    <div className="quick-filter flex-hz">
      <h3 className="flex-hz">
        <i className="fa-solid fa-arrow-down-wide-short"></i>
        مرتب سازی بر اساس:
      </h3>
      <div className="filter-labels flex-hz">
        <div
          onClick={() => setOpenMobileFilters(true)}
          className="mobile-filter flex-hz"
        >
          <FilterMobile />
          <span>فیلتر</span>
        </div>
        <input
          type="radio"
          name="quick-filter"
          id="filter-most-pop-courses"
          defaultChecked={true}
        />
        <input type="radio" name="quick-filter" id="filter-most-price" />
        <input type="radio" name="quick-filter" id="filter-lowest-price" />
        <input type="radio" name="quick-filter" id="filter-latest-courses" />
        <input type="radio" name="quick-filter" id="filter-most-discount" />
        <label
          htmlFor="filter-most-pop-courses"
          className="flex-hz"
          onClick={() => {
            sortHandler("rating");
            setCurrentPage(1);
          }}
        >
          <i className="fa-duotone fa-square-check"></i>
          پرفروش‌ترین‌
        </label>
        <label
          htmlFor="filter-most-price"
          className="flex-hz"
          onClick={() => {
            sortHandler("price", "toMin");
            setCurrentPage(1);
          }}
        >
          <i className="fa-duotone fa-square-check"></i>
          گران‌ترین
        </label>
        <label
          htmlFor="filter-lowest-price"
          className="flex-hz"
          onClick={() => {
            sortHandler("price", "toMax");
            setCurrentPage(1);
          }}
        >
          <i className="fa-duotone fa-square-check"></i>
          ارزان‌ترین
        </label>
        <label
          htmlFor="filter-latest-courses"
          className="flex-hz"
          onClick={() => {
            sortHandler("date");
            setCurrentPage(1);
          }}
        >
          <i className="fa-duotone fa-square-check"></i>
          جدیدترین
        </label>
        <label
          htmlFor="filter-most-discount"
          className="flex-hz"
          onClick={() => {
            sortHandler("discount");
            setCurrentPage(1);
          }}
        >
          <i className="fa-duotone fa-square-check"></i>
          بیشترین تخفیف
        </label>
      </div>
      {openMobileFilters ? (
        <MobileFilters setOpenMobileFilters={setOpenMobileFilters} />
      ) : null}
    </div>
  );
};

export default ShopQuickFilters;
