"use client";

import "./ShowTime.css";
import {formatDistanceToNow, parseISO} from "date-fns-jalali";
import {useEffect, useState} from "react";

const ShowTime = ({timeStamp, distance = false}) => {
    const [timeAgo, setTimeAgo] = useState("");
    const [jalaliDate, setJalaliDate] = useState("");

    useEffect(() => {
        if (distance) {
            let parsedTime = parseISO(timeStamp),
                targetTime = formatDistanceToNow(parsedTime);
            setTimeAgo(targetTime);
        }
    }, []);

    useEffect(() => {
        if (!distance) {
            let options = {
                year: 'numeric',
                month: 'long',
                day: 'numeric',
                hour: 'numeric',
                minute: 'numeric',
            };
            let targetDate = new Date(timeStamp).toLocaleDateString('fa-IR', options);
            setJalaliDate(targetDate)
        }
    }, []);

    return (
        <>
            {
                distance ? (
                    <span className="show-time">
                        {timeAgo} پیش
                    </span>
                ) : (
                    <span className="show-time">
                        {jalaliDate}
                    </span>
                )
            }
        </>
    );
};

export default ShowTime;