"use client";

import "./ShowTime.css";
import {useEffect, useState} from "react";

const ShowTime2 = ({timeStamp}) => {
    const [jalaliDate, setJalaliDate] = useState("");

    useEffect(() => {
        let options = {
            year: 'numeric',
            month: 'long',
            day: 'numeric',
        };
        let targetDate = new Date(timeStamp).toLocaleDateString('fa-IR', options);
        setJalaliDate(targetDate);
    }, []);

    return (
        <span className="show-time">
              {jalaliDate}
        </span>
    );
};

export default ShowTime2;