"use client";

import "./ProductColorSelector.css";

const colors = ["#F19E17", "#006FBB", "#50B83C", "#e11030", "#EE00CEFF",]

const ProductColorSelector = () => {
    const

        colorSelector = (e, color) => {
            e.target.parentElement.querySelectorAll("li").forEach(item => {
                item.classList.remove("active");
            })
            e.target.classList.add("active")
            e.target.style.borderColor = color;
        }


    return (
        <ul className="flex-hz colors-list">
            {
                colors.map((color, index) => (
                    <li
                        className={`flex-hz ${index === 0 ? "active" : ""}`}
                        style={{borderColor: `${index === 0 ? color : ""}`}}
                        key={color}
                        onClick={(e)=> {
                            colorSelector(e, color)
                        }}
                    >
                        <span
                            className="flex-hz"
                            style={{backgroundColor: color}}
                        ></span>
                    </li>
                ))
            }
        </ul>
    );
};

export default ProductColorSelector;