"use client";

import AddToWishList from "@/components/addToWishList/AddToWishList";
import ShareProduct from "@/components/shareProduct/ShareProduct";
import StarVectorSvg2 from "@/components/customSvgVectors/StarVectorSvg2";
import ProductColorSelector from "@/components/targetProductMainDetails/ProductColorSelector";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Toman from "@/components/toman/Toman";
import { useState } from "react";
import CartOptionsBtn from "@/components/cartOptionsBtn/CartOptionsBtn";

const TargetProductMainDetails = () => {
  const [isInCart, setIsInCart] = useState(false);

  return (
    <div className="target-product-main-details flex-vr">
      <div className="target-product-main-detail-div1 flex-hz">
        <h5 className="flex-hz">
          دسته بندی:
          <span>پوشاک مردانه</span>
        </h5>
        <div className="target-product-main-detail-div1-btns flex-hz">
          <AddToWishList />
          <ShareProduct />
        </div>
      </div>
      <div className="target-product-main-detail-div2 flex-hz">
        <h2 className="product-title">
          کاپشن مردانه جک اند جونز مدل BIG Parka
        </h2>
        <div className="product-score flex-hz">
          4.7
          <StarVectorSvg2 />
        </div>
      </div>
      <div className="target-product-main-detail-div3 flex-hz">
        <div className="manufacturer-label flex-hz">
          برند:
          <span>جک اند جونز</span>
        </div>
        <div className="manufacturer-label flex-hz">
          کشور سازنده:
          <span>دانمارک</span>
        </div>
      </div>
      <div className="target-product-main-detail-div4 colors flex-vr">
        <h4>رنگ:</h4>
        <ProductColorSelector />
      </div>
      <div className="target-product-main-detail-div4-5 colors flex-vr">
        <h4>سایز:</h4>
        <select name="size" id="size">
          <option value="">S</option>
          <option value="">M</option>
          <option value="">L</option>
          <option value="">XL</option>
          <option value="">XXL</option>
        </select>
      </div>
      <div className="target-product-main-detail-div5 colors flex-hz">
        <div className="target-product-main-detail-div5-right-side flex-vr">
          <h3 className="flex-hz">
            ویژگی های محصول
            <a href="#details-table" className="flex-hz btn">
              <i className="fa-duotone fa-eye"></i>
              مشخصات کامل
            </a>
          </h3>
          <ul className="flex-vr">
            <li className="flex-hz">
              جنس :<span>الیاف مصنوعی</span>
            </li>
            <li className="flex-hz">
              قد :<span>روی باسن</span>
            </li>
            <li className="flex-hz">
              مورد استفاده :<span>اسپرت، روزمره، مهمانی</span>
            </li>
          </ul>
        </div>
        <div className="target-product-main-detail-div5-left-side flex-vr">
          <div className="target-product-discount flex-hz">
            <s>6,800,000</s>
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span>20%</span>
            </div>
          </div>
          <div className="target-product-price flex-hz">
            <span>5,440,000</span>
            <Toman />
          </div>
          {isInCart ? (
            <CartOptionsBtn />
          ) : (
            <button className="add-to-cart btn flex-hz">
              افزودن به سبد خرید
              {/*<i className="fa-duotone fa-spinner-third fa-spin" style={{"--fa-secondary-opacity": "0.1"}}></i>*/}
            </button>
          )}
        </div>
      </div>
      <div className="target-product-main-detail-extra-message flex-hz">
        <i className="fa-duotone fa-circle-exclamation"></i>
        <p>
          درخواست مرجوع کردن کالا با دلیل &#34;انصراف از خرید&#34; تنها در صورتی
          قابل تایید است که کالا در شرایط اولیه باشد (در صورت پلمپ بودن، کالا
          نباید باز شده باشد).
        </p>
      </div>
    </div>
  );
};

export default TargetProductMainDetails;
