"use client";

import "./TargetProductVoting.css";
import VeryBadReactionSvg from "@/components/customSvgVectors/VeryBadReactionSvg";
import BadReactionSvg from "@/components/customSvgVectors/BadReactionSvg";
import AverageReactionSvg from "@/components/customSvgVectors/AverageReactionSvg";
import GoodReactionSvg from "@/components/customSvgVectors/GoodReactionSvg";
import VeryGoodReactionSvg from "@/components/customSvgVectors/VeryGoodReactionSvg";
import {toast} from "react-toastify";
import {useEffect, useState} from "react";
import {useSelector} from "react-redux";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";

const TargetProductVoting = () => {

    const
        isLoggedIn = useSelector(selectLoggedInStatus),
        [isVoted, setIsVoted] = useState(false),
        [classNamePhrase, setClassNamePhrase] = useState(""),
        [voterCount, setVoterCount] = useState(""),
        votingHandler = e => {
            e.target.parentElement.querySelectorAll("div.vote-frame").forEach(item => {
                item.classList.remove("active");
            });
            e.target.classList.add("active");
            setIsVoted(true);
        };

    useEffect(() => {
        setVoterCount((Math.random() * (100 - 20) + 20).toFixed(0).toString());
    }, []);

    useEffect(() => {
        if (isLoggedIn) {
            setClassNamePhrase("target-product-voting logged flex-vr");
        } else {
            setClassNamePhrase("target-product-voting flex-vr");
        }
    }, [isLoggedIn]);

    return (
        <div className={classNamePhrase}>
            <div className="target-product-voting-div1 flex-hz">
                <ul className="score-analytics flex-vr">
                    <li className="flex-hz">
                        <div className="slider-bar flex-hz">
                            <span
                                className="flex-hz"
                                style={{width: "60%"}}
                            ></span>
                        </div>
                        <span className="flex-hz">5</span>
                    </li>
                    <li className="flex-hz">
                        <div className="slider-bar flex-hz">
                            <span
                                className="flex-hz"
                                style={{width: "10%"}}
                            ></span>
                        </div>
                        <span className="flex-hz">4</span>
                    </li>
                    <li className="flex-hz">
                        <div className="slider-bar flex-hz">
                            <span
                                className="flex-hz"
                                style={{width: "20%"}}
                            ></span>
                        </div>
                        <span className="flex-hz">3</span>
                    </li>
                    <li className="flex-hz">
                        <div className="slider-bar flex-hz">
                            <span
                                className="flex-hz"
                                style={{width: "6%"}}
                            ></span>
                        </div>
                        <span className="flex-hz">2</span>
                    </li>
                    <li className="flex-hz">
                        <div className="slider-bar flex-hz">
                            <span
                                className="flex-hz"
                                style={{width: "4%"}}
                            ></span>
                        </div>
                        <span className="flex-hz">1</span>
                    </li>
                </ul>
                <div className="score-container flex-vr">
                    <h1>
                        4.7
                    </h1>
                    <ul
                        className="flex-hz stars-cont flex-hz"
                    >
                        <li>
                            <i className="fa-solid fa-star"></i>
                        </li>
                        <li>
                            <i className="fa-solid fa-star"></i>
                        </li>
                        <li>
                            <i className="fa-solid fa-star"></i>
                        </li>
                        <li>
                            <i className="fa-solid fa-star"></i>
                        </li>
                        <li>
                            <i className="fa-regular fa-star-half-stroke"></i>
                        </li>
                    </ul>
                    <span>{`از مجموع ${voterCount} امتیاز`}</span>
                </div>
            </div>
            <h3>
                به این محصول امتیاز دهید!
            </h3>
            <div className="vote-reactions-cont flex-hz">
                <div className="vote-frame flex-vr" onClick={votingHandler}>
                    <div className="vote-svg-cont">
                        <VeryBadReactionSvg/>
                    </div>
                    خیلی بد
                </div>
                <div className="vote-frame flex-vr" onClick={votingHandler}>
                    <div className="vote-svg-cont">
                        <BadReactionSvg/>
                    </div>
                    بد
                </div>
                <div className="vote-frame flex-vr" onClick={votingHandler}>
                    <div className="vote-svg-cont">
                        <AverageReactionSvg/>
                    </div>
                    معمولی
                </div>
                <div className="vote-frame flex-vr" onClick={votingHandler}>
                    <div className="vote-svg-cont">
                        <GoodReactionSvg/>
                    </div>
                    خوب
                </div>
                <div className="vote-frame flex-vr" onClick={votingHandler}>
                    <div className="vote-svg-cont">
                        <VeryGoodReactionSvg/>
                    </div>
                    عالی
                </div>
            </div>
            <button
                className="btn flex-hz"
                onClick={() => toast.success("رای شما با موفقیت ثبت شد!")}
                disabled={!isVoted}
            >
                ثبت امتیاز
            </button>
        </div>
    );
};

export default TargetProductVoting;