"use client";

import {useEffect, useState} from 'react';
import {nanoid} from "nanoid";
import {useSelector} from "react-redux";
import {selectToken, selectUserInfo} from "@/reducers/athenticationSlice";
import TinyLoader from "@/components/preloader/TinyLoader";
import {creatComment_Server} from "@/services/apiServices";
import {toast} from "react-toastify";

const TextInputSubComment = ({setChildrenComments, setReply, comment, blogId}) => {
    const
        userInfo = useSelector(selectUserInfo),
        token = useSelector(selectToken),
        [targetContact, setTargetContact] = useState(""),
        [textareaValue, setTextareaValue] = useState(""),
        [creatingSubCommentLoading, setCreatingSubCommentLoading] = useState(false);

    useEffect(() => {
        setTargetContact(comment);
    }, [comment]);

    const
        onChangeTextareaValueHandler = e => setTextareaValue(e.target.value),
        addReplyComment = async () => {
            try {
                setCreatingSubCommentLoading(true);
                const
                    {status} = await creatComment_Server(
                        blogId,
                        {
                            body: textareaValue,
                            comment_id: comment.id
                        },
                        token
                    );
                if (status === 200) {
                    setCreatingSubCommentLoading(false);
                    toast.success("دیدگاه شما با موفقیت ثبت گردید!");
                    setChildrenComments(draft => {
                        draft.push({
                            id: nanoid(),
                            body: textareaValue,
                            user_id: `admin-dji-7fSWI-lck`,
                            name: `${userInfo.first_name} ${userInfo.last_name}`,
                            image: "Logo.webp",
                            created_at: "لحظاتی پیش",
                            likes: 0,
                            dislikes: 0,
                            comments: []
                        });
                    });
                    // setInputValue("");
                    setReply(false);
                } else {
                    setCreatingSubCommentLoading(false);
                    toast.error("خطایی پیش آمد، مجددا تلاش کنید");
                }
            } catch (e) {
                console.log(e.error);
            }
        }

    return (
        <>
            <textarea
                name="" id=""
                placeholder={`پاسخ خود را به ${targetContact?.name} در اینجا بنویسید...`}
                value={textareaValue}
                onChange={onChangeTextareaValueHandler}
            />
            <div className="submit-reply-button-container flex-hz">
                <button
                    className="submit-reply btn flex-hz"
                    onClick={addReplyComment}
                    disabled={creatingSubCommentLoading}
                >
                    ثبت نظر
                </button>
                {creatingSubCommentLoading && <TinyLoader/>}
            </div>
        </>
    )
};

export default TextInputSubComment;