"use client";

import {ErrorMessage, Field, Form, Formik} from "formik";
import {useEffect, useState} from "react";
import MapSvg from "@/components/customSvgVectors/MapSvg";
import {AddressFormValidationSchema} from "@/validations/AddressFormValidationSchema";

const AddressForm = ({numberValidator, type, disablePopUpMode, userInfo = null}) => {
    const
        [inputPostalCodeValue, setInputPostalCodeValue] = useState(""),
        [addressValue, setAddressValue] = useState("");

    useEffect(() => {
        userInfo && setInputPostalCodeValue(userInfo?.first_name);
        userInfo && setAddressValue(userInfo?.last_name);
    }, [userInfo]);

    return (
        <Formik
            initialValues={{
                postal_code: "",
                address: ""
            }}
            validationSchema={AddressFormValidationSchema}
            onSubmit={values => {
                console.log(values);
            }}
        >
            {({setFieldValue})=> (
                <Form autoComplete="off" className="flex-vr">
                    <div className="top-bar-edit-form flex-hz">
                        <MapSvg/>
                        <h3 className="flex-vr">
                            {type === "add" ? (
                                "افزودن آدرس جدید"
                            ) : "ویرایش آدرس"}
                            <span>لطفاً مشخصات خود را وارد کنید.</span>
                        </h3>
                        <button
                            type="button"
                            className="flex-vr btn"
                            onClick={disablePopUpMode}
                        >
                            <i className="fa-regular fa-xmark"></i>
                        </button>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="postal_code">کد پستی</label>
                        <Field
                            type="text"
                            id="postal_code"
                            name="postal_code"
                            maxLength="10"
                            value={inputPostalCodeValue}
                            onChange={e => setInputPostalCodeValue(e.target.value)}
                            onKeyUp={numberValidator}
                        />
                        <ErrorMessage name="postal_code" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="address">آدرس کامل گیرنده</label>
                        <Field
                            type="hidden"
                            id="address"
                            name="address"
                        />
                        <textarea
                            value={addressValue}
                            onChange={e => setAddressValue(e.target.value)}
                        />
                        <ErrorMessage name="address" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        onClick={() => {
                            setFieldValue("postal_code", inputPostalCodeValue);
                            setFieldValue("address", addressValue);
                        }}
                        // disabled={status === "reg-loading" || status === "log-loading"}
                    >
                        {type === "add" ? (
                            "ثبت آدرس"
                        ) : "ویرایش آدرس"}
                    </button>
                    {/*{status === "reg-loading" && <TinyLoader/> || status === "log-loading" && <TinyLoader/>}*/}
                </Form>
            )}
        </Formik>
    );
};

export default AddressForm;