"use client";

import MapPhotoSvg from "@/components/customSvgVectors/MapPhotoSvg";
import LocationIconSvg from "@/components/customSvgVectors/LocationIconSvg";
import PostalCodeIconSvg from "@/components/customSvgVectors/PostalCodeIconSvg";
import PenIconSvg from "@/components/customSvgVectors/PenIconSvg";
import TrashIconSvg from "@/components/customSvgVectors/TrashIconSvg";
import { useEffect, useRef, useState } from "react";
import AddressForm from "@/components/userDashboard/AddressForm";

const DashAddressCard = ({ numberValidator }) => {
  const targetElementRef = useRef(),
    [isAddressOptionWindowActive, setIsAddressOptionWindowActive] =
      useState(false),
    [isEditAddressFormActive, setIsEditAddressFormActive] = useState(false),
    addressOptionRevealer = (e) => {
      setIsAddressOptionWindowActive((prevState) => !prevState);
    },
    disablePopUpMode = () => {
      if (typeof document !== "undefined") {
        document.querySelector("main").classList.remove("pop-up-mode");
        setIsEditAddressFormActive(false);
      }
    },
    enablePopUpMode = () => {
      if (typeof document !== "undefined") {
        document.querySelector("main").classList.add("pop-up-mode");
      }
      setIsEditAddressFormActive(true);
    };

  useEffect(() => {
    if (typeof document !== "undefined") {
      const handleClick = (e) => {
        if (!targetElementRef.current.contains(e.target)) {
          setIsAddressOptionWindowActive(false);
        }
      };

      document.body.addEventListener("click", handleClick);
      return () => document.body.removeEventListener("click", handleClick);
    }
  }, []);

  return (
    <div className="address-card flex-hz">
      <MapPhotoSvg />
      <div className="address-card-text-contents flex-vr">
        <div className="flex-hz">
          <LocationIconSvg />
          تهران، فلکه دوم تهرانپارس، کوچه 180 غربی، پلاک 38، طبقه دوم واحد 4
        </div>
        <div className="flex-hz">
          <PostalCodeIconSvg />
          5032514950
        </div>
      </div>
      <div className="address-options-cont flex-vr" ref={targetElementRef}>
        <button
          className={`address-options-btn btn flex-vr ${
            isAddressOptionWindowActive ? "active" : ""
          }`}
          onClick={addressOptionRevealer}
        >
          <i className="fa-regular fa-ellipsis-vertical"></i>
        </button>
        <ul
          className={`flex-vr ${isAddressOptionWindowActive ? "active" : ""}`}
        >
          <li className="flex-hz" onClick={enablePopUpMode}>
            <PenIconSvg />
            ویرایش آدرس
          </li>
          <li className="flex-hz">
            <TrashIconSvg />
            حذف آدرس
          </li>
        </ul>
        <div
          className={`address-form-container flex-vr ${
            isEditAddressFormActive ? "active" : ""
          }`}
        >
          <AddressForm
            disablePopUpMode={disablePopUpMode}
            numberValidator={numberValidator}
            type="edit"
          />
        </div>
      </div>
    </div>
  );
};

export default DashAddressCard;
