import OrderStatusStep1 from "@/components/customSvgVectors/OrderStatusStep1";
import OrderStatusStep2 from "@/components/customSvgVectors/OrderStatusStep2";
import OrderStatusStep3 from "@/components/customSvgVectors/OrderStatusStep3";
import OrderStatusStep4 from "@/components/customSvgVectors/OrderStatusStep4";
import OrderStatusStep5 from "@/components/customSvgVectors/OrderStatusStep5";

const DashOrderStatusStepsProgress = ({stepNo}) => {
    return (
        <ul className="order-status-steps-progress flex-hz">
            <li className={`flex-hz ${stepNo >= 0 ? "active" : ""}`}>
                <OrderStatusStep1/>
                <span>ثبت سفارش</span>
            </li>
            <li className={`flex-hz ${stepNo >= 1 ? "active" : ""}`}>
                <OrderStatusStep2/>
                <span>تایید سفارش</span>
            </li>
            <li className={`flex-hz ${stepNo >= 2 ? "active" : ""}`}>
                <OrderStatusStep3/>
                <span> بسته بندی و آماده ارسال</span>
            </li>
            <li className={`flex-hz ${stepNo >= 3 ? "active" : ""}`}>
                <OrderStatusStep4/>
                <span>ارسال شده</span>
            </li>
            <li className={`flex-hz ${stepNo >= 4 ? "active" : ""}`}>
                <OrderStatusStep5/>
                <span>تحویل داده شد</span>
            </li>
            <div className="order-status-steps-progress-bar flex-hz">
                <div className={`progress-bar-slice flex-hz ${stepNo > 0 ? "active" : ""}`}></div>
                <div className={`progress-bar-slice flex-hz ${stepNo > 1 ? "active" : ""}`}></div>
                <div className={`progress-bar-slice flex-hz ${stepNo > 2 ? "active" : ""}`}></div>
                <div className={`progress-bar-slice flex-hz ${stepNo > 3 ? "active" : ""}`}></div>
            </div>
        </ul>
    );
};

export default DashOrderStatusStepsProgress;