"use client";

import "./DashboardAddressesDetails.css";
import AddressForm from "@/components/userDashboard/AddressForm";
import {useSelector} from "react-redux";
import {selectUserInfo} from "@/reducers/athenticationSlice";
import {isSafari} from "react-device-detect";
import DashAddressCard from "@/components/userDashboard/DashAddressCard";

const DashboardAddressesTabContent = ({params}) => {
    const
        userInfo = useSelector(selectUserInfo),
        enablePopUpMode = e => {
            if (typeof document !== "undefined") {
                document.querySelector("main").classList.add("pop-up-mode");
            }
            e.target.nextElementSibling.classList.add("active");
        },
        disablePopUpMode = e => {
            if (typeof document !== "undefined") {
                document.querySelector("main").classList.remove("pop-up-mode");
                e.target.parentElement.parentElement.parentElement.classList.remove("active");
            }
        },
        numberValidator = e => {
            if (!isSafari) {
                let value = e.target.value.replace(/\D/g, "");
                e.target.value = value;
            }
        };

    return (
        <div className="dash-addresses-cont flex-vr">
            <div className="dash-addresses-top-bar flex-hz">
                <div className="flex-hz">
                    <h2 className="title">
                        آدرس های من
                    </h2>
                </div>
                <button
                    className="flex-hz insert-address btn"
                    onClick={enablePopUpMode}
                >
                    <i className="fa-solid fa-circle-plus"></i>
                    آدرس جدید
                </button>
                <div className="address-form-container flex-vr">
                    <AddressForm
                        disablePopUpMode={disablePopUpMode}
                        numberValidator={numberValidator}
                        type="add"
                    />
                </div>
            </div>
            <div className="address-cards-cont flex-vr">
               <DashAddressCard
                   disablePopUpMode={disablePopUpMode}
                   numberValidator={numberValidator}
               />
               <DashAddressCard
                   numberValidator={numberValidator}
               />
            </div>
        </div>
    );
};

export default DashboardAddressesTabContent;