import "./DashboardHomeTabContent.css";
import RegisteredOrdersIconSvg from "@/components/customSvgVectors/RegisteredOrdersIconSvg";
import SentOrdersIconSvg from "@/components/customSvgVectors/SentOrdersIconSvg";
import ReturnedOrdersIconSvg from "@/components/customSvgVectors/ReturnedOrdersIconSvg";
import Link from "next/link";

const DashboardHomeTabContent = () => {
    return (
        <div className="dashboard-home-tab-content flex-vr">
            <div className="dashboard-home-tab-content-div1 flex-vr">
                <div className="dash-box-header flex-hz">
                    <h2 className="title">
                        سفارشات من
                    </h2>
                </div>
                <div className="orders-status-widgets-cont flex-hz">
                    <div className="orders-status-widget-card registered-orders flex-hz">
                        <div className="svg-cont">
                            <RegisteredOrdersIconSvg/>
                        </div>
                        <h3 className="flex-vr">
                            <span>سفارش های ثبت شده</span>
                            28
                        </h3>
                    </div>
                    <div className="orders-status-widget-card sent-orders flex-hz">
                        <div className="svg-cont">
                            <SentOrdersIconSvg/>
                        </div>
                        <h3 className="flex-vr">
                            <span>سفارش های تحویل شده</span>
                            26
                        </h3>
                    </div>
                    <div className="orders-status-widget-card returned-orders flex-hz">
                        <div className="svg-cont">
                            <ReturnedOrdersIconSvg/>
                        </div>
                        <h3 className="flex-vr">
                            <span>سفارش های مرجوع شده</span>
                            2
                        </h3>
                    </div>
                </div>
            </div>
            <div className="dashboard-home-tab-content-div2 flex-vr">
                <div className="dash-box-header flex-hz">
                    <h2 className="title">
                        سفارشات اخیر
                    </h2>
                    <Link href={`/user-dashboard/orders/all-items`} className="flex-hz">
                        همه سفارش ها
                        <i className="fa-regular fa-chevron-left"></i>
                    </Link>
                </div>
                <div className="latest-orders-table flex-vr">
                    <Link href={`/user-dashboard/orders/tms-23124`} className="flex-hz">
                        <ul className="flex-hz">
                            <li className="order-title flex-hz">
                                شماره سفارش :
                                <span>VR02133</span>
                            </li>
                            <li className="order-date flex-hz">
                                دوشنبه 11 بهمن 1402
                            </li>
                            <li className="order-payment flex-hz">
                                پرداخت : 600,000 تومان
                            </li>
                            <li className="order-status flex-hz">
                                <span className="status-label in_progress flex-hz">
                                    در حال پردازش
                                </span>
                            </li>
                            <li className="flex-hz">
                                <i className="fa-regular fa-chevron-left"></i>
                            </li>
                        </ul>
                    </Link>
                    <Link href={`/user-dashboard/orders/tms-23124`} className="flex-hz">
                        <ul className="flex-hz">
                            <li className="order-title flex-hz">
                                شماره سفارش :
                                <span>VR01435</span>
                            </li>
                            <li className="order-date flex-hz">
                                دوشنبه 11 بهمن 1402
                            </li>
                            <li className="order-payment flex-hz">
                                پرداخت : 600,000 تومان
                            </li>
                            <li className="order-status flex-hz">
                                <span className="status-label ready-for-sending flex-hz">
                                    آماده ارسال
                                </span>
                            </li>
                            <li className="flex-hz">
                                <i className="fa-regular fa-chevron-left"></i>
                            </li>
                        </ul>
                    </Link>
                    <Link href={`/user-dashboard/orders/tms-23124`} className="flex-hz">
                        <ul className="flex-hz">
                            <li className="order-title flex-hz">
                                شماره سفارش :
                                <span>VR05371</span>
                            </li>
                            <li className="order-date flex-hz">
                                دوشنبه 2 بهمن 1402
                            </li>
                            <li className="order-payment flex-hz">
                                پرداخت : 800,000 تومان
                            </li>
                            <li className="order-status flex-hz">
                                <span className="status-label sent flex-hz">
                                    ارسال شده
                                </span>
                            </li>
                            <li className="flex-hz">
                                <i className="fa-regular fa-chevron-left"></i>
                            </li>
                        </ul>
                    </Link>
                    <Link href={`/user-dashboard/orders/tms-23124`} className="flex-hz">
                        <ul className="flex-hz">
                            <li className="order-title flex-hz">
                                شماره سفارش :
                                <span>VR05941</span>
                            </li>
                            <li className="order-date flex-hz">
                                دوشنبه 25 دی 1402
                            </li>
                            <li className="order-payment flex-hz">
                                پرداخت : 950,000 تومان
                            </li>
                            <li className="order-status flex-hz">
                                <span className="status-label canceled flex-hz">
                                    لغو شده
                                </span>
                            </li>
                            <li className="flex-hz">
                                <i className="fa-regular fa-chevron-left"></i>
                            </li>
                        </ul>
                    </Link>
                </div>
            </div>
        </div>
    );
};

export default DashboardHomeTabContent;