"use client";

import "./DashboardOrdersTabContent.css";
import Link from "next/link";
import DashOrdersDivider from "@/components/userDashboard/dashOrdersDivider";
import DashOrderSearchBar from "@/components/userDashboard/DashOrderSearchBar";
import DashOrderDetailsIconSvg from "@/components/customSvgVectors/DashOrderDetailsIconSvg";
import OrderInProgressIconSvg from "@/components/customSvgVectors/orderInProgressIconSvg";
import Toman from "@/components/toman/Toman";
import Image from "next/image";
import OrderCanceledIconSvg from "@/components/customSvgVectors/OrderCanceledIconSvg";
import OrderSuccessIconSvg from "@/components/customSvgVectors/OrderSuccessIconSvg";
import OrderReadyForSendingIconSvg from "@/components/customSvgVectors/OrderReadyForSendingIconSvg";

const DashboardOrdersTabContent = ({params}) => {

    return (
        <div className="dashboard-order-tab-content flex-vr">
            <div className="dash-box-header flex-hz">
                <h2 className="title">
                    تاریخچه سفارشات
                </h2>
            </div>
            <DashOrdersDivider params={params}/>
            <DashOrderSearchBar/>
            <div className="dashboard-orders-cards-cont flex-vr">
                <div className="dash-order-card flex-vr">
                    <Link href={`/user-dashboard/target-order/tms-847234`} className="order-details btn flex-hz">
                        <DashOrderDetailsIconSvg/>
                        جزئیات سفارش
                    </Link>
                    <div className="dash-order-card-text-details flex-hz">
                        <div className="order-status-icon flex-hz">
                            <OrderInProgressIconSvg/>
                        </div>
                        <div className="dash-order-card-text-sub-details flex-vr">
                            <h3 className="in-progress">
                                در حال پردازش
                            </h3>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    شماره سفارش :
                                    <span>VR3210</span>
                                </div>
                            </div>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    تاریخ :
                                    <div className="sub-divider">دوشنبه 15 بهمن 1402</div>
                                </div>
                                <div className="flex-hz">
                                    مبلغ :
                                    <div className="sub-divider flex-hz">
                                        600,000
                                        <Toman/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="dash-order-card-photos-items flex-hz">
                        <Image
                            src="/images/product-test3.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test4.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test5.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                    </div>
                </div>
            </div>
            <div className="dashboard-orders-cards-cont flex-vr">
                <div className="dash-order-card flex-vr">
                    <Link href={`/user-dashboard/target-order/tms-847234`} className="order-details btn flex-hz">
                        <DashOrderDetailsIconSvg/>
                        جزئیات سفارش
                    </Link>
                    <div className="dash-order-card-text-details flex-hz">
                        <div className="order-status-icon flex-hz">
                            <OrderCanceledIconSvg/>
                        </div>
                        <div className="dash-order-card-text-sub-details flex-vr">
                            <h3 className="cancelled">
                                لغو شده
                            </h3>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    شماره سفارش :
                                    <span>VR3210</span>
                                </div>
                            </div>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    تاریخ :
                                    <div className="sub-divider">شنبه 13 بهمن 1402</div>
                                </div>
                                <div className="flex-hz">
                                    مبلغ :
                                    <div className="sub-divider flex-hz">
                                        350,000
                                        <Toman/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="dash-order-card-photos-items flex-hz">
                        <Image
                            src="/images/product-test12.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                    </div>
                </div>
            </div>
            <div className="dashboard-orders-cards-cont flex-vr">
                <div className="dash-order-card flex-vr">
                    <Link href={`/user-dashboard/target-order/tms-847234`} className="order-details btn flex-hz">
                        <DashOrderDetailsIconSvg/>
                        جزئیات سفارش
                    </Link>
                    <div className="dash-order-card-text-details flex-hz">
                        <div className="order-status-icon flex-hz">
                            <OrderSuccessIconSvg/>
                        </div>
                        <div className="dash-order-card-text-sub-details flex-vr">
                            <h3 className="success">
                                ارسال شده
                            </h3>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    شماره سفارش :
                                    <span>VR3210</span>
                                </div>
                            </div>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    تاریخ :
                                    <div className="sub-divider">شنبه 7 بهمن 1402</div>
                                </div>
                                <div className="flex-hz">
                                    مبلغ :
                                    <div className="sub-divider flex-hz">
                                        2,550,000
                                        <Toman/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="dash-order-card-photos-items flex-hz">
                        <Image
                            src="/images/product-test7.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test39.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test8.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test9.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test10.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        4+
                    </div>
                </div>
            </div>
            <div className="dashboard-orders-cards-cont flex-vr">
                <div className="dash-order-card flex-vr">
                    <Link href={`/user-dashboard/target-order/tms-847234`} className="order-details btn flex-hz">
                        <DashOrderDetailsIconSvg/>
                        جزئیات سفارش
                    </Link>
                    <div className="dash-order-card-text-details flex-hz">
                        <div className="order-status-icon flex-hz">
                            <OrderReadyForSendingIconSvg/>
                        </div>
                        <div className="dash-order-card-text-sub-details flex-vr">
                            <h3 className="ready-to-send">
                                آماده ارسال
                            </h3>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    شماره سفارش :
                                    <span>VR3242</span>
                                </div>
                            </div>
                            <div className="flex-hz">
                                <div className="flex-hz">
                                    تاریخ :
                                    <div className="sub-divider">دوشنبه 2 بهمن 1402</div>
                                </div>
                                <div className="flex-hz">
                                    مبلغ :
                                    <div className="sub-divider flex-hz">
                                        740,000
                                        <Toman/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="dash-order-card-photos-items flex-hz">
                        <Image
                            src="/images/product-test31.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                        <Image
                            src="/images/product-test35.webp"
                            alt="photo"
                            width={500}
                            height={500}
                        />
                    </div>
                </div>
            </div>
        </div>
    );
};

export default DashboardOrdersTabContent;