"use client";

import "./DashboardProfileTabContent.css";
import {isSafari} from "react-device-detect";
import {useDispatch, useSelector} from "react-redux";
import {
    authMe,
    authStatusIdealHandler,
    selectAuthenticationStatus, selectToken,
    selectUserInfo
} from "@/reducers/athenticationSlice";
import PenIconSvg from "@/components/customSvgVectors/PenIconSvg";
import EditNameForm from "@/components/userDashboard/EditNameForm";
import EditMobileForm from "@/components/userDashboard/EditMobileForm";
import EditEmailForm from "@/components/userDashboard/EditEmailForm";
import EditBankAccountForm from "@/components/userDashboard/EditBankAccountForm";
import {useEffect} from "react";
import {toast} from "react-toastify";

const DashboardProfileTabContent = () => {
    const
        token = useSelector(selectToken),
        dispatch = useDispatch(),
        userInfo = useSelector(selectUserInfo),
        status = useSelector(selectAuthenticationStatus),
        enablePopUpMode = (e) => {
            if (typeof document !== "undefined") {
                document.querySelector("main").classList.add("pop-up-mode");
            }
            e.target.parentElement.nextElementSibling.classList.add("active");
        },
        disablePopUpMode = (e) => {
            if (typeof document !== "undefined") {
                document.querySelector("main").classList.remove("pop-up-mode");
                e.target.parentElement.parentElement.parentElement.classList.remove(
                    "active"
                );
            }
        },
        numberValidator = (e) => {
            if (!isSafari) {
                let value = e.target.value.replace(/\D/g, "");
                e.target.value = value;
            }
        },
        wordValidator = (e) => {
            let value = e.target.value.replace(/\d/, "");
            e.target.value = value;
        };

    useEffect(() => {
        if (status === "edit-profile-updated") {
            if (token) {
                dispatch(authMe(token));
                toast.success("حساب کاربری شما با موفقیت بروزرسانی شد!");
                dispatch(authStatusIdealHandler());
            }
        }
    }, [status]);

    return (
        <div className="dashboard-profile-tab-content flex-vr">
            <div className="dash-box-header flex-hz">
                <h2 className="title">مشخصات حساب کاربری</h2>
            </div>
            <div className="profile-details-cont">
                <div className="flex-vr">
                    <h3>نام و نام خانوادگی :</h3>
                    <div className="value-container flex-hz">
                        {userInfo ? (
                            `${userInfo?.first_name} ${userInfo?.last_name}`
                        ) : (
                            <i className="fa-light fa-spinner-third fa-spin"></i>
                        )}
                        <button className="btn edit-btn" onClick={enablePopUpMode}>
                            <PenIconSvg/>
                        </button>
                    </div>
                    <div className="edit-form-container flex-vr">
                        <EditNameForm
                            disablePopUpMode={disablePopUpMode}
                            wordValidator={wordValidator}
                            userInfo={userInfo}
                        />
                    </div>
                </div>
                <div className="flex-vr">
                    <h3>شماره تلفن همراه :</h3>
                    <div className="value-container flex-hz">
                        {userInfo ? (
                            userInfo?.phone_number
                        ) : (
                            <i className="fa-light fa-spinner-third fa-spin"></i>
                        )}
                        <button className="btn edit-btn" onClick={enablePopUpMode}>
                            <PenIconSvg/>
                        </button>
                    </div>
                    <div className="edit-form-container flex-vr">
                        <EditMobileForm
                            disablePopUpMode={disablePopUpMode}
                            numberValidator={numberValidator}
                            userInfo={userInfo}
                        />
                    </div>
                </div>
                <div className="flex-vr">
                    <h3>پست الکترونیک :</h3>
                    <div className="value-container flex-hz">
                        {userInfo ? (
                            userInfo?.email
                        ) : (
                            <i className="fa-light fa-spinner-third fa-spin"></i>
                        )}
                        <button className="btn edit-btn" onClick={enablePopUpMode}>
                            <PenIconSvg/>
                        </button>
                    </div>
                    <div className="edit-form-container flex-vr">
                        <EditEmailForm
                            disablePopUpMode={disablePopUpMode}
                            userInfo={userInfo}
                        />
                    </div>
                </div>
                <div className="flex-vr">
                    <h3>شماره حساب بانکی/شبا :</h3>
                    <div className="value-container flex-hz">
                        {/*{userInfo ? userInfo?.email :*/}
                        {/*    <i className="fa-light fa-spinner-third fa-spin"></i>}*/}
                        <button className="btn edit-btn" onClick={enablePopUpMode}>
                            <PenIconSvg/>
                        </button>
                    </div>
                    <div className="edit-form-container flex-vr">
                        <EditBankAccountForm
                            disablePopUpMode={disablePopUpMode}
                            numberValidator={numberValidator}
                            userInfo={userInfo}
                        />
                    </div>
                </div>
            </div>
        </div>
    );
};

export default DashboardProfileTabContent;
