"use client";

import "./DashboardTargetOrderDetails.css";
import Link from "next/link";
import ArrowRightIconSvg from "@/components/customSvgVectors/ArrowRightIconSvg";
import {useState} from "react";
import DashOrderStatusStepsProgress from "@/components/userDashboard/DashOrderStatusStepsProgress";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";
import Toman from "@/components/toman/Toman";

const DashboardTargetOrderDetails = ({params}) => {
    const
        [stepNo, setStepNo] = useState(2);


    return (
        <div className="dash-target-order-details-cont flex-vr">
            <div className="dash-target-order-details-top-bar flex-hz">
                <div className="flex-hz">
                    <Link href={`/user-dashboard/orders/all-items`} className="flex-hz">
                        <ArrowRightIconSvg/>
                    </Link>
                    <h2 className="title">
                        جزئیات سفارش
                    </h2>
                </div>
                <a href="#" className="flex-hz download-invoice">
                    <i className="fa-regular fa-download"></i>
                    دانلود فاکتور
                </a>
            </div>
            <DashOrderStatusStepsProgress stepNo={stepNo}/>
            <div className="dash-target-order-main-details flex-vr">
                <div className="dash-target-order-main-details-div1 flex-hz">
                    <div className="flex-vr">
                        <h4 className="flex-hz">
                            شماره سفارش:
                            <span> VR3210</span>
                        </h4>
                        <h4 className="flex-hz">
                            مبلغ سفارش:
                            <span> 600,000 تومان</span>
                        </h4>
                        <h4 className="flex-hz">
                            تاریخ ثبت سفارش:
                            <span> سه شنبه 11 بهمن 1402</span>
                        </h4>
                    </div>
                    <div className="flex-vr">
                        <h4 className="flex-hz">
                            تاریخ ارسال سفارش:
                            <span> چهارشنبه 12 بهمن 1402</span>
                        </h4>
                        <h4 className="flex-hz">
                            هزینه ارسال:
                            <span>رایگان</span>
                        </h4>
                        <h4 className="flex-hz">
                            کد رهگیری:
                            <span>-</span>
                        </h4>
                    </div>
                </div>
                <div className="dash-target-order-main-details-div2 flex-vr">
                    <div className="flex-hz">
                        <h4 className="flex-hz">
                            تحویل گیرنده:
                            <span>آرش کمانگیر</span>
                        </h4>
                        <h4 className="flex-hz">
                            تلفن همراه:
                            <span>09126847925</span>
                        </h4>
                    </div>
                    <div className="flex-hz">
                        <h4 className="flex-hz">
                            آدرس:
                            <span> تهران، خیابان ستارخان، خیابان پاتریس لومومبا، کوچه نریمان، پلاک 16، واحد4</span>
                        </h4>
                    </div>
                </div>
            </div>
            <div className="dash-target-order-items flex-vr">
                <Link href={`/product/tms-512367`} className="dash-target-order-item-card flex-hz">
                    <div className="dash-target-order-item-card-div-right flex-hz">
                        <figure className="flex-hz">
                            <div className="discount-label flex-hz">
                                <DiscountLabelSvg/>
                                <span>18%</span>
                            </div>
                            <Image
                                src="/images/product-test3.webp"
                                alt="photo"
                                width={600}
                                height={600}
                            />
                        </figure>
                        <div className="dash-target-order-item-card-texts-details flex-vr">
                            <h3>
                                عینک آفتابی ری بن مدل RB3609-914071
                            </h3>
                            <div className="color flex-hz">
                                <span className="flex-hz" style={{borderColor: "#355203"}}>
                                    <span style={{background: "#355203"}}></span>
                                </span>
                                <span>
                                    سبز زیتونی
                                </span>
                            </div>
                            <div className="quantity flex-hz">
                                <span>تعداد:</span>
                                <span>1 عدد</span>
                            </div>
                            <div className="guarantee-msg flex-hz">
                                <i className="fa-solid fa-shield-check"></i>
                                گارانتی اصالت و سلامت فیزیکی کالا
                            </div>
                        </div>
                    </div>
                    <div className="dash-target-order-item-price-cont flex-hz">
                        <h3>
                            180,000
                        </h3>
                        <Toman/>
                    </div>
                </Link>
                <Link href={`/product/tms-691367`} className="dash-target-order-item-card flex-hz">
                    <div className="dash-target-order-item-card-div-right flex-hz">
                        <figure className="flex-hz">
                            <div className="discount-label flex-hz">
                                <DiscountLabelSvg/>
                                <span>11%</span>
                            </div>
                            <Image
                                src="/images/view-product1.webp"
                                alt="photo"
                                width={600}
                                height={600}
                            />
                        </figure>
                        <div className="dash-target-order-item-card-texts-details flex-vr">
                            <h3>
                                کاپشن مردانه جک اند جونز مدل BIG Parka
                            </h3>
                            <div className="color flex-hz">
                                <span className="flex-hz" style={{borderColor: "#ffa900"}}>
                                    <span style={{background: "#ffa900"}}></span>
                                </span>
                                <span>
                                    زرد
                                </span>
                            </div>
                            <div className="quantity flex-hz">
                                <span>تعداد:</span>
                                <span>1 عدد</span>
                            </div>
                            <div className="guarantee-msg flex-hz">
                                <i className="fa-solid fa-shield-check"></i>
                                گارانتی اصالت و سلامت فیزیکی کالا
                            </div>
                        </div>
                    </div>
                    <div className="dash-target-order-item-price-cont flex-hz">
                        <h3>
                            920,000
                        </h3>
                        <Toman/>
                    </div>
                </Link>
            </div>
        </div>
    );
};

export default DashboardTargetOrderDetails;