"use client";

import {ErrorMessage, Field, Form, Formik} from "formik";
import {useEffect, useState} from "react";
import ShebaLogoSvg from "@/components/customSvgVectors/ShebaLogoSvg";
import {ShebaValidationSchema} from "@/validations/ShebaValidationSchema";

const EditBankAccountForm = ({numberValidator, disablePopUpMode, userInfo}) => {
    const
        [inputShebaValue, setInputShebaValue] = useState("");

    // useEffect(() => {
    //     userInfo && setInputMobileValue(userInfo?.username);
    // }, [userInfo]);

    return (
        <Formik
            initialValues={{
                sheba: "",
            }}
            validationSchema={ShebaValidationSchema}
            onSubmit={values => {
                console.log(values);
            }}
        >
            {({setFieldValue})=> (
                <Form autoComplete="off" className="flex-vr">
                    <div className="top-bar-edit-form flex-hz">
                        <ShebaLogoSvg/>
                        <h3 className="flex-vr">
                            ویرایش/ثبت شماره حساب بانکی
                            <span>لطفا 24 رقم شماره شبا حساب بانکی خود را وارد کنید.</span>
                        </h3>
                        <button
                            type="button"
                            className="flex-vr btn"
                            onClick={disablePopUpMode}
                        >
                            <i className="fa-regular fa-xmark"></i>
                        </button>
                    </div>
                    <div className="input-group flex-vr">
                        <span id="sheba" className="flex-hz">IR</span>
                        <label className="flex-hz" htmlFor="sheba">شماره شبا</label>
                        <Field
                            type="text"
                            id="sheba"
                            name="sheba"
                            maxLength="24"
                            onKeyUp={numberValidator}
                            value={inputShebaValue}
                            onChange={e => setInputShebaValue(e.target.value)}
                        />
                        <ErrorMessage name="sheba" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        onClick={()=> setFieldValue("sheba", inputShebaValue)}
                        // disabled={status === "reg-loading" || status === "log-loading"}
                    >
                        تایید اطلاعات
                    </button>
                    {/*{status === "reg-loading" && <TinyLoader/> || status === "log-loading" && <TinyLoader/>}*/}
                </Form>
            )}
        </Formik>
    );
};

export default EditBankAccountForm;