"use client";

import {ErrorMessage, Field, Form, Formik} from "formik";
import {useEffect, useRef, useState} from "react";
import {UpdateEmailValidationSchema} from "@/validations/UpdateEmailValidationSchema";
import EnvelopIconSvg from "@/components/customSvgVectors/EnvelopIconSvg";
import {useDispatch, useSelector} from "react-redux";
import {selectAuthenticationStatus, selectToken, updateUserProfileInformation} from "@/reducers/athenticationSlice";
import TinyLoader from "@/components/preloader/TinyLoader";

const EditEmailForm = ({disablePopUpMode, userInfo}) => {
    const
        dispatch = useDispatch(),
        token = useSelector(selectToken),
        status = useSelector(selectAuthenticationStatus),
        [inputEmailValue, setInputEmailValue] = useState(""),
        refCloserBtn = useRef(null);

    useEffect(() => {
        userInfo && userInfo?.email !== null && setInputEmailValue(userInfo?.email);
    }, [userInfo]);

    useEffect(() => {
        if (status === "edit-profile-updated") {
            if (token) {
                refCloserBtn.current.click();
            }
        }
    }, [status]);

    return (
        <Formik
            initialValues={{
                email: "",
            }}
            validationSchema={UpdateEmailValidationSchema}
            onSubmit={values => {
                dispatch(updateUserProfileInformation({
                    token,
                    email: values.email
                }));
            }}
        >
            {({setFieldValue}) => (
                <Form autoComplete="off" className="flex-vr">
                    <div className="top-bar-edit-form flex-hz">
                        <EnvelopIconSvg/>
                        <h3 className="flex-vr">
                            ویرایش آدرس ایمیل
                            <span>برای ویرایش، آدرس ایمیل جدید خود را وارد کنید.</span>
                        </h3>
                        <button
                            type="button"
                            className="flex-vr btn"
                            onClick={disablePopUpMode}
                            ref={refCloserBtn}
                        >
                            <i className="fa-regular fa-xmark"></i>
                        </button>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="email">آدرس ایمیل</label>
                        <Field
                            type="text"
                            id="email"
                            name="email"
                            value={inputEmailValue}
                            onChange={e => setInputEmailValue(e.target.value)}
                        />
                        <ErrorMessage name="email" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        onClick={() => setFieldValue("email", inputEmailValue)}
                        disabled={status === "edit-profile-loading"}
                    >
                        تایید اطلاعات
                    </button>
                    {status === "edit-profile-loading" && <TinyLoader/>}
                </Form>
            )}
        </Formik>
    );
};

export default EditEmailForm;