"use client";

import {ErrorMessage, Field, Form, Formik} from "formik";
import MobileIconSvg from "@/components/customSvgVectors/MobileIconSvg";
import {useEffect, useRef, useState} from "react";
import {useDispatch, useSelector} from "react-redux";
import {
    selectAuthenticationStatus,
    selectToken,
    updateUserProfileInformation
} from "@/reducers/athenticationSlice";
import TinyLoader from "@/components/preloader/TinyLoader";
import {EditMobileValidationSchema} from "@/validations/EditMobileValidationSchema";

const EditMobileForm = ({numberValidator, disablePopUpMode, userInfo}) => {
    const
        dispatch = useDispatch(),
        token = useSelector(selectToken),
        status = useSelector(selectAuthenticationStatus),
        [inputMobileValue, setInputMobileValue] = useState(""),
        refCloserBtn = useRef(null);

    useEffect(() => {
        userInfo && setInputMobileValue(userInfo?.phone_number);
    }, [userInfo]);

    useEffect(() => {
        if (status === "edit-profile-updated") {
            if (token) {
                refCloserBtn.current.click();
            }
        }
    }, [status]);

    return (
        <Formik
            initialValues={{
                phone_number: "",
            }}
            validationSchema={EditMobileValidationSchema}
            onSubmit={values => {
                dispatch(updateUserProfileInformation({
                    token,
                    phone_number: values.phone_number
                }));
            }}
        >
            {({setFieldValue}) => (
                <Form autoComplete="off" className="flex-vr">
                    <div className="top-bar-edit-form flex-hz">
                        <MobileIconSvg/>
                        <h3 className="flex-vr">
                            ویرایش شماره موبایل
                            <span>برای ویرایش، شماره موبایل جدید خود را وارد کنید.</span>
                        </h3>
                        <button
                            type="button"
                            className="flex-vr btn"
                            onClick={disablePopUpMode}
                            ref={refCloserBtn}
                        >
                            <i className="fa-regular fa-xmark"></i>
                        </button>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="phone_number">شماره موبایل</label>
                        <Field
                            type="text"
                            id="phone_number"
                            name="phone_number"
                            maxLength="11"
                            onKeyUp={numberValidator}
                            value={inputMobileValue}
                            onChange={e => setInputMobileValue(e.target.value)}
                        />
                        <ErrorMessage name="phone_number" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        onClick={() => setFieldValue("phone_number", inputMobileValue)}
                        disabled={status === "edit-profile-loading"}
                    >
                        ویرایش اطلاعات
                    </button>
                    {status === "edit-profile-loading" && <TinyLoader/>}
                </Form>
            )}
        </Formik>
    );
};

export default EditMobileForm;