"use client";

import {ErrorMessage, Field, Form, Formik} from "formik";
import CircleUserSvg from "@/components/customSvgVectors/CircleUserSvg";
import {useEffect, useRef, useState} from "react";
import {useDispatch, useSelector} from "react-redux";
import {
    selectAuthenticationStatus,
    selectToken,
    updateUserProfileInformation
} from "@/reducers/athenticationSlice";
import TinyLoader from "@/components/preloader/TinyLoader";
import {UpdateNameValidationSchema} from "@/validations/UpdateNameValidationSchema";

const EditNameForm = ({wordValidator, disablePopUpMode, userInfo}) => {
    const
        dispatch = useDispatch(),
        token = useSelector(selectToken),
        status = useSelector(selectAuthenticationStatus),
        [inputFNameValue, setInputFNameValue] = useState(""),
        [inputLNameValue, setInputLNameValue] = useState(""),
        refCloserBtn = useRef(null);

    useEffect(() => {
        userInfo && setInputFNameValue(userInfo?.first_name);
        userInfo && setInputLNameValue(userInfo?.last_name);
    }, [userInfo]);

    useEffect(() => {
        if (status === "edit-profile-updated") {
            if (token) {
                refCloserBtn.current.click();
            }
        }
    }, [status]);

    return (
        <Formik
            initialValues={{
                first_name: "",
                last_name: "",
            }}
            validationSchema={UpdateNameValidationSchema}
            onSubmit={values => {
                dispatch(updateUserProfileInformation({
                    token,
                    first_name: values.first_name,
                    last_name: values.last_name
                }));
            }}
        >
            {({setFieldValue}) => (
                <Form autoComplete="off" className="flex-vr">
                    <div className="top-bar-edit-form flex-hz">
                        <CircleUserSvg/>
                        <h3 className="flex-vr">
                            ثبت اطلاعات شناسایی
                            <span>لطفاً مشخصات خود را وارد کنید.</span>
                        </h3>
                        <button
                            type="button"
                            className="flex-vr btn"
                            onClick={disablePopUpMode}
                            ref={refCloserBtn}
                        >
                            <i className="fa-regular fa-xmark"></i>
                        </button>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="first_name">نام</label>
                        <Field
                            type="text"
                            id="first_name"
                            name="first_name"
                            maxLength="21"
                            onKeyUp={wordValidator}
                            value={inputFNameValue}
                            onChange={e => setInputFNameValue(e.target.value)}
                        />
                        <ErrorMessage name="first_name" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="last_name">نام خانوادگی</label>
                        <Field
                            type="text"
                            id="last_name"
                            name="last_name"
                            maxLength="21"
                            onKeyUp={wordValidator}
                            value={inputLNameValue}
                            onChange={e => setInputLNameValue(e.target.value)}
                        />
                        <ErrorMessage name="last_name" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        onClick={() => {
                            setFieldValue("first_name", inputFNameValue);
                            setFieldValue("last_name", inputLNameValue);
                        }}
                        disabled={status === "edit-profile-loading"}
                    >
                        ویرایش اطلاعات
                    </button>
                    {status === "edit-profile-loading" && <TinyLoader/>}
                </Form>
            )}
        </Formik>
    );
};

export default EditNameForm;