"use client";

import "./UserDashboard.css";
import {useEffect} from "react";
import {useSelector} from "react-redux";
import {useRouter} from "next/navigation";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";
import DashboardHomeTabContent from "@/components/userDashboard/DashboardHomeTabContent";
import DashboardOrdersTabContent from "@/components/userDashboard/DashboardOrdersTabContent";
import DashboardTargetOrderDetails from "@/components/userDashboard/DashboardTargetOrderDetails";
import DashboardProfileTabContent from "@/components/userDashboard/DashboardProfileTabContent";
import DashboardAddressesTabContent from "@/components/userDashboard/DashboardAddressesTabContent";
import DashboardMessagesTabContent from "@/components/userDashboard/DashboardMessagesTabContent";
import DashboardWishListTabContent from "@/components/userDashboard/DashboardWishListTabContent";
import DashboardDiscountCodesTabContent from "@/components/userDashboard/DashboardDiscountCodesTabContent";

const UserDashboard = ({params}) => {
    const
        navigate = useRouter(),
        isUserLoggedIn = useSelector(selectLoggedInStatus);

    useEffect(() => {
        typeof window !== "undefined" && window.scrollTo({top: 0}) && window.location.reload(true);
    }, []);

    useEffect(() => {
        let timout;
        timout = setTimeout(() => {
            !isUserLoggedIn && navigate.push("/");

        }, 1500);

        return () => clearTimeout(timout);
    }, [isUserLoggedIn]);

    return (
        <div className="user-dashboard flex-vr">
            {params.userDashboard[0] === "home" && <DashboardHomeTabContent/>}
            {params.userDashboard[0] === "profile" && <DashboardProfileTabContent params={params}/>}
            {params.userDashboard[0] === "orders" && <DashboardOrdersTabContent params={params}/>}
            {params.userDashboard[0] === "target-order" && <DashboardTargetOrderDetails params={params}/>}
            {params.userDashboard[0] === "addresses" && <DashboardAddressesTabContent params={params}/>}
            {params.userDashboard[0] === "messages" && <DashboardMessagesTabContent params={params}/>}
            {params.userDashboard[0] === "wishlist" && <DashboardWishListTabContent params={params}/>}
            {params.userDashboard[0] === "discount-codes" && <DashboardDiscountCodesTabContent params={params}/>}
        </div>
    );
};

export default UserDashboard;