import Link from "next/link";

const DashOrdersDivider = ({params}) => {
    return (
        <div className="dash-orders-divider flex-hz">
            <ul className="flex-hz">
                <li className={`flex-hz ${params.userDashboard[1] === "all-items" ? "active" : ""}`}>
                    <Link href={`/user-dashboard/orders/all-items`} className="flex-hz">
                        تمام سفارشات
                        <span className="flex-hz">4</span>
                    </Link>
                </li>
                <li className={`flex-hz ${params.userDashboard[1] === "sent" ? "active" : ""}`}>
                    <Link href={`/user-dashboard/orders/sent`} className="flex-hz">
                        تحویل شده
                        <span className="flex-hz">2</span>
                    </Link>
                </li>
                <li className={`flex-hz ${params.userDashboard[1] === "cancelled" ? "active" : ""}`}>
                    <Link href={`/user-dashboard/orders/cancelled`} className="flex-hz">
                        لغو شده
                        <span className="flex-hz">1</span>
                    </Link>
                </li>
                <li className={`flex-hz ${params.userDashboard[1] === "returned" ? "active" : ""}`}>
                    <Link href={`/user-dashboard/orders/returned`} className="flex-hz">
                        مرجوع شده
                        <span className="flex-hz">1</span>
                    </Link>
                </li>
            </ul>
        </div>
    );
};

export default DashOrdersDivider;