"use client";

import "./VoteArticle.css";
import {useEffect, useRef, useState} from "react";
import VeryGoodReactionSvg from "@/components/customSvgVectors/VeryGoodReactionSvg";
import GoodReactionSvg from "@/components/customSvgVectors/GoodReactionSvg";
import AverageReactionSvg from "@/components/customSvgVectors/AverageReactionSvg";
import BadReactionSvg from "@/components/customSvgVectors/BadReactionSvg";
import VeryBadReactionSvg from "@/components/customSvgVectors/VeryBadReactionSvg";
import {toast} from "react-toastify";
import {useDispatch, useSelector} from "react-redux";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";
import {confirmAlertHandler} from "@/reducers/confirmAlertSlice";

const VoteArticle = () => {
    const
        isLoggedIn = useSelector(selectLoggedInStatus),
        dispatch = useDispatch(),
        [isVotingWindowOpen, setIsVotingWindowOpen] = useState(false),
        [voteNo, setVoteNo] = useState(0),
        targetElementRef = useRef(),

        openVotingWindowHandler = ()=> {
            if (isLoggedIn) {
                setIsVotingWindowOpen(prevState => !prevState);
            } else {
                dispatch(confirmAlertHandler(true));
            }
        },
        votingHandler = ()=> {
            setIsVotingWindowOpen(prevState => !prevState);
            toast.success("رای شما با موفقیت ثبت شد!")
        }

    useEffect(() => {
        if (typeof document !== "undefined") {
            const handleClick = e => {
                if (!targetElementRef.current.contains(e.target)) {
                    setIsVotingWindowOpen(false);
                }
            }

            document.body.addEventListener("click", handleClick);
            return () => document.body.removeEventListener("click", handleClick);
        }
    }, []);


    return (
        <div className="vote-article flex-hz">
            به این مطلب امتیاز دهید:
            <div className="vote-system-cont" ref={targetElementRef}>
                <ul
                    className="flex-hz stars-cont flex-hz"
                    onClick={openVotingWindowHandler}
                >
                    <li>
                        <i className="fa-solid fa-star"></i>
                    </li>
                    <li>
                        <i className="fa-solid fa-star"></i>
                    </li>
                    <li>
                        <i className="fa-solid fa-star"></i>
                    </li>
                    <li>
                        <i className="fa-solid fa-star"></i>
                    </li>
                    <li>
                        <i className="fa-regular fa-star-half-stroke"></i>
                    </li>
                </ul>
                <div
                    className={`voting-window flex-vr ${isVotingWindowOpen ? "active" : ""}`}
                >
                    <h3>
                        به این مقاله امتیاز دهید !
                    </h3>
                    <div className="vote-reactions-cont flex-hz">
                        <div className="flex-vr" onClick={votingHandler}>
                            <div className="vote-svg-cont">
                                <VeryBadReactionSvg/>
                            </div>
                            خیلی بد
                        </div>
                        <div className="flex-vr" onClick={votingHandler}>
                            <div className="vote-svg-cont">
                                <BadReactionSvg/>
                            </div>
                            بد
                        </div >
                        <div className="flex-vr" onClick={votingHandler}>
                            <div className="vote-svg-cont">
                                <AverageReactionSvg/>
                            </div>
                            معمولی
                        </div>
                        <div className="flex-vr" onClick={votingHandler}>
                            <div className="vote-svg-cont">
                                <GoodReactionSvg/>
                            </div>
                            خوب
                        </div>
                        <div className="flex-vr" onClick={votingHandler}>
                            <div className="vote-svg-cont">
                                <VeryGoodReactionSvg/>
                            </div>
                            عالی
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default VoteArticle;