import {createSlice} from "@reduxjs/toolkit";

const
    confirmAlertSlice = createSlice({
        name: "confirmAlert",
        initialState: {
            isConfirmAlertOpen: false
        },
        reducers: {
            confirmAlertHandler: (state, action) => {
                state.isConfirmAlertOpen = action.payload;
            }
        }
    });

export const
    selectConfirmAlertStatus = state => state.confAlert.isConfirmAlertOpen,
    {confirmAlertHandler} = confirmAlertSlice.actions;

export default confirmAlertSlice.reducer;