import {createAsyncThunk, createSlice} from "@reduxjs/toolkit";
import {fetchMegaMenuItems_Server} from "@/services/apiServices";

export const
    fetchMegaMenuCategories = createAsyncThunk(
        "megaMenu/fetchCategories",
        async () => {
            try {
                const response = await fetchMegaMenuItems_Server();
                return response.data;
            } catch (e) {
                throw e.response.data;
            }
        }
    );

const
    megaMenuCategoriesSlice = createSlice({
        name: "megaMenuCategories",
        initialState: {
            megaMenuCategories: [],
            status: "idle"
        },
        reducers: {},
        extraReducers: (builder) => {
            builder
                .addCase(fetchMegaMenuCategories.pending, (state) => {
                    state.status = "loading";
                })
                .addCase(fetchMegaMenuCategories.fulfilled, (state, action) => {
                    state.status = "completed";
                    state.megaMenuCategories = action.payload.result.data;
                })
                .addCase(fetchMegaMenuCategories.rejected, (state) => {
                    state.status = "failed";
                })
        }
    });

export const
    selectMegaMenuCategories = state => state.megaMenu.megaMenuCategories,
    selectConfirmAlertStatus = state => state.megaMenu.status;

export default megaMenuCategoriesSlice.reducer;