import axios from "axios";

const
    baseUrl = "https://demobackend.versalikoshop.com";

export const
    register_Server = values => {
        return axios.post(`${baseUrl}/user/register`, values);
    },
    login_Server = values => {
        return axios.post(`${baseUrl}/user/verification_request`, values);
    },
    otpCheck_Server = (values) => {
        return axios.post(`${baseUrl}/user/confirm_otp`, values);
    },
    authMe_Server = (token) => {
        return axios.post(`${baseUrl}/user/profile_user`, {token});
    },
    updateUserProfileInfo_Server = (values) => {
        return axios.post(`${baseUrl}/user/editprofile_user`, values);
    },
    fetchMegaMenuItems_Server = () => {
        return axios.get(`${baseUrl}/categories`);
    },
    creatComment_Server = (slug, data, token) => {
        return axios.post(`${baseUrl}/posts/${slug}/comments`, data, {
            headers: {
                Authorization: `Bearer ${token}`
            },
        });
    }