import * as Yup from "yup";

export const LoginValidationSchema = Yup.object().shape({
    phone: Yup.string()
        .min(11, "شماره نامعتبر است")
        .max(11, "شماره نامعتبر است")
        .required("شماره موبایل الزامی است")
        .matches(
            /^((\+[1-9]{1,4}[ -]?)|(\([0-9]{2,3}\)[ -]?)|([0-9]{2,4})[ -]?)*?[0-9]{3,4}[ -]?[0-9]{3,4}$/,
            "شماره نامعتبر است"
        ),
});