import * as Yup from "yup";

export const RegisterValidationSchema = Yup.object().shape({
    first_name: Yup.string()
        .min(2, "یک نام معتبر وارد کنید")
        .required("نام الزامی است"),
    last_name: Yup.string()
        .min(2, "یک نام معتبر وارد کنید")
        .required("نام خانوادگی الزامی است"),
    phone: Yup.string()
        .min(11, "شماره نامعتبر است")
        .max(11, "شماره نامعتبر است")
        .required("شماره موبایل الزامی است")
        .matches(
            /^((\+[1-9]{1,4}[ -]?)|(\([0-9]{2,3}\)[ -]?)|([0-9]{2,4})[ -]?)*?[0-9]{3,4}[ -]?[0-9]{3,4}$/,
            "شماره نامعتبر است"
        )
});